export type ReferralStatus = 'pending' | 'qualified' | 'paid' | 'rejected';
export type ReferralSource = 'signup' | 'invite' | 'campaign';

export interface Referral {
  id: string;
  referrer_id: string;
  referred_user_id: string;
  source: ReferralSource;
  status: ReferralStatus;
  reward: number;
  created_at: string;
  updated_at: string;
}

export interface RegisterReferralRequest {
  referrer_code: string;
}

export interface AdminReviewReferralRequest {
  status: 'paid' | 'rejected';
} 